/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc;

import ibm.nways.jdm.database.DatabaseEvent;
import ibm.nways.jdm.database.DatabaseListener;
import ibm.nways.jdm.database.jdbc.DbJdbcConnection;
import ibm.nways.jdm.database.jdbc.DbListener;
import java.util.Enumeration;
import java.util.Vector;

class DbJdbcNotifier
implements Runnable {
    private Thread serviceThread;
    private DbJdbcConnection connection;
    private Vector dbListeners = new Vector();

    public DbJdbcNotifier(DbJdbcConnection dbJdbcConnection) {
        this.connection = dbJdbcConnection;
        this.serviceThread = new Thread(this);
    }

    public void run() {
        DatabaseEvent databaseEvent = null;
        while (!(databaseEvent = this.connection.getNextNotifyEvent()).getShutdown()) {
            boolean bl = false;
            Enumeration enumeration = this.dbListeners.elements();
            while (enumeration.hasMoreElements()) {
                DbListener dbListener = (DbListener)enumeration.nextElement();
                switch (dbListener.condition) {
                    case 1: {
                        bl = databaseEvent.getReturnCode() < 0;
                        break;
                    }
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 3: {
                        bl = !this.connection.hasWork() && !databaseEvent.getMoreWork();
                        break;
                    }
                }
                if (!bl) continue;
                dbListener.listener.databaseRequestCompleted(databaseEvent);
            }
        }
        this.connection = null;
        this.stop();
    }

    void start() {
        this.serviceThread.start();
    }

    void stop() {
        this.serviceThread.stop();
    }

    public synchronized void addDatabaseListener(DatabaseListener databaseListener, int n) {
        DbListener dbListener = new DbListener();
        dbListener.listener = databaseListener;
        dbListener.condition = n;
        if (this.dbListeners.isEmpty()) {
            this.start();
        }
        this.dbListeners.addElement(dbListener);
    }

    public synchronized void removeDatabaseListener(DatabaseListener databaseListener) {
        Enumeration enumeration = this.dbListeners.elements();
        DbListener dbListener = null;
        while (enumeration.hasMoreElements() && dbListener == null) {
            dbListener = (DbListener)enumeration.nextElement();
            if (dbListener.listener == databaseListener) continue;
            dbListener = null;
        }
        if (dbListener != null) {
            this.dbListeners.removeElement(dbListener);
            if (this.dbListeners.isEmpty()) {
                this.stop();
            }
        }
    }

    public synchronized boolean areThereListeners() {
        return !this.dbListeners.isEmpty();
    }
}

